/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure;

import com.yurtmod.block.BlockTentDoor;
import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.Content;
import com.yurtmod.structure.StructureType;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class StructureBase {
    protected final StructureType structure;
    public static final Predicate<IBlockState> REPLACE_BLOCK_PRED = new Predicate<IBlockState>(){

        @Override
        public boolean test(IBlockState b) {
            Material m = b.func_185904_a();
            return m.func_76222_j() || m == Material.field_151579_a || m == Material.field_151585_k || m == Material.field_151587_i || m == Material.field_151586_h || m == Material.field_151584_j || m == Material.field_151597_y || m == Material.field_151582_l || b.func_177230_c() instanceof BlockSnow;
        }
    };
    protected static final String DOOR = "door";
    protected static final String BARRIER = "barrier";
    protected static final String WALL = "wall";
    protected static final String ROOF = "roof";

    public StructureBase(StructureType type) {
        this.structure = type;
    }

    public StructureType getType() {
        return this.structure;
    }

    public final boolean generateInTentDimension(int prevDimension, World worldIn, int cornerX, int cornerZ, double prevX, double prevY, double prevZ) {
        BlockPos corner = new BlockPos(cornerX, 70, cornerZ);
        BlockPos doorPos = new BlockPos(cornerX, 71, cornerZ + this.structure.getDoorPosition());
        if (worldIn.func_180495_p(doorPos).func_177230_c() instanceof BlockTentDoor) {
            StructureBase.updateDoorInfo(worldIn, doorPos, cornerX, cornerZ, this.structure, prevX, prevY, prevZ, prevDimension);
            return false;
        }
        boolean success = this.generate(worldIn, doorPos, TentDimension.STRUCTURE_DIR, this.structure.getSize(), this.structure.getDoorBlock(), this.structure.getWallBlock(TentDimension.DIMENSION_ID), this.structure.getRoofBlock());
        if (success) {
            StructureBase.generatePlatform(worldIn, corner, this.structure.getSize());
            worldIn.func_175726_f(doorPos).func_76603_b();
            StructureBase.updateDoorInfo(worldIn, doorPos, cornerX, cornerZ, this.structure, prevX, prevY, prevZ, prevDimension);
            return true;
        }
        return false;
    }

    public static final boolean updateDoorInfo(World worldIn, BlockPos doorPos, int cornerX, int cornerZ, StructureType structure, double prevX, double prevY, double prevZ, int prevDimension) {
        TileEntity te = worldIn.func_175625_s(doorPos);
        if (te != null && te instanceof TileEntityTentDoor) {
            TileEntityTentDoor door = (TileEntityTentDoor)te;
            door.setStructureType(structure);
            door.setOffsetX(TileEntityTentDoor.getChunkOffsetX(cornerX));
            door.setOffsetZ(TileEntityTentDoor.getChunkOffsetZ(cornerZ));
            door.setOverworldXYZ(prevX, prevY, prevZ);
            door.setPrevDimension(prevDimension);
            return true;
        }
        System.out.println("[StructureBase] Error! Failed to retrieve TileEntityTentDoor at " + doorPos.toString());
        return false;
    }

    private static boolean generatePlatform(World worldIn, BlockPos corner, StructureType.Size size) {
        int sqWidth = size.getSquareWidth();
        for (int i = 0; i < sqWidth; ++i) {
            for (int j = 0; j < sqWidth; ++j) {
                Block topState;
                BlockPos at = corner.func_177982_a(i, 0, j);
                Block above = worldIn.func_180495_p(at.func_177981_b(1)).func_177230_c();
                Block block = topState = above instanceof BlockUnbreakable ? Content.SUPER_DIRT : Blocks.field_150346_d;
                if (worldIn.func_175623_d(at) || topState == Content.SUPER_DIRT) {
                    worldIn.func_180501_a(at, topState.func_176223_P(), 2);
                }
                worldIn.func_180501_a(at.func_177979_c(1), Content.SUPER_DIRT.func_176223_P(), 2);
            }
        }
        return true;
    }

    public static final BlockPos getPosFromDoor(BlockPos doorPos, BlockPos offset, EnumFacing forward) {
        return StructureBase.getPosFromDoor(doorPos, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), forward);
    }

    public static final BlockPos getPosFromDoor(BlockPos doorPos, int disForward, int disUp, int disRight, EnumFacing forward) {
        EnumFacing right = forward.func_176746_e();
        return doorPos.func_177967_a(forward, disForward).func_177967_a(right, disRight).func_177981_b(disUp);
    }

    public static void buildDoor(World world, BlockPos doorBase, Block door, EnumFacing dir) {
        IBlockState doorL = door.func_176223_P();
        IBlockState doorU = door.func_176223_P();
        if (door instanceof BlockTentDoor) {
            EnumFacing.Axis axis = dir.func_176740_k().equals((Object)EnumFacing.Axis.Z) ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
            doorL = doorL.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a(BlockTentDoor.AXIS, (Comparable)axis);
            doorU = doorU.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a(BlockTentDoor.AXIS, (Comparable)axis);
        }
        world.func_180501_a(doorBase, doorL, 3);
        world.func_180501_a(doorBase.func_177981_b(1), doorU, 3);
    }

    public void buildLayer(World worldIn, BlockPos door, EnumFacing dirForward, IBlockState state, BlockPos[] coordinates) {
        for (BlockPos coord : coordinates) {
            BlockPos pos = StructureBase.getPosFromDoor(door, coord, dirForward);
            worldIn.func_180501_a(pos, state, 3);
        }
    }

    public void buildLayer(World worldIn, BlockPos door, EnumFacing dirForward, Block block, BlockPos[] coordinates) {
        this.buildLayer(worldIn, door, dirForward, block.func_176223_P(), coordinates);
    }

    public boolean generateFrameStructure(World worldIn, BlockPos doorBase, EnumFacing dirForward, StructureType.Size size) {
        return this.generate(worldIn, doorBase, dirForward, size, this.getType().getDoorBlock(), this.getType().getFrameBlock(false), this.getType().getFrameBlock(true));
    }

    public boolean remove(World worldIn, BlockPos doorPos, EnumFacing dirForward, StructureType.Size size) {
        boolean flag = this.generate(worldIn, doorPos, dirForward, size, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a);
        if (worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
            worldIn.func_175713_t(doorPos);
        }
        if (worldIn.func_175625_s(doorPos.func_177981_b(1)) instanceof TileEntityTentDoor) {
            worldIn.func_175713_t(doorPos.func_177981_b(1));
        }
        return flag;
    }

    public static final boolean validateArray(World worldIn, BlockPos doorPos, BlockPos[] posArray, EnumFacing facing, Predicate<IBlockState> predicate) {
        for (BlockPos p : posArray) {
            BlockPos check = StructureBase.getPosFromDoor(doorPos, p, facing);
            if (StructureBase.validateBlock(worldIn, check, predicate)) continue;
            return false;
        }
        return true;
    }

    public static final boolean validateBlock(World worldIn, BlockPos pos, Predicate<IBlockState> p) {
        return p.test(worldIn.func_180495_p(pos));
    }

    public EnumFacing getValidFacing(World worldIn, BlockPos doorBase) {
        StructureType.Size s = this.getType().getSize();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            boolean isValid = this.isValidForFacing(worldIn, doorBase, StructureType.Size.SMALL, dir);
            if (!isValid) continue;
            return dir;
        }
        return null;
    }

    public abstract boolean generate(World var1, BlockPos var2, EnumFacing var3, StructureType.Size var4, Block var5, Block var6, Block var7);

    public abstract boolean canSpawn(World var1, BlockPos var2, EnumFacing var3, StructureType.Size var4);

    public abstract boolean isValidForFacing(World var1, BlockPos var2, StructureType.Size var3, EnumFacing var4);
}

